<?php
// Ensure this file is used within the context of header.php where is_active_page is defined
if (!function_exists('is_active_page')) {
    // Fallback if not included via header.php (though it should be)
    function is_active_page($page_name) {
        $current_page = basename($_SERVER['PHP_SELF'] ?? 'dashboard.php');
        if ($current_page === $page_name) {
            return 'bg-indigo-700 hover:bg-indigo-600 dark:bg-indigo-600 dark:hover:bg-indigo-500';
        }
        return '';
    }
}
?>

<!-- Sidebar Overlay (for Mobile) -->
<div id="sidebar-overlay" class="fixed inset-0 bg-black opacity-50 z-30 hidden md:hidden" onclick="toggleSidebar()"></div>

<!-- Sidebar itself -->
<aside id="sidebar" class="bg-indigo-900 dark:bg-gray-900 w-64 p-4 flex flex-col shadow-2xl z-40
        fixed h-full top-0 left-0
        md:flex transform -translate-x-full md:translate-x-0 transition-transform duration-300">
    
    <div class="text-white dark:text-indigo-400 text-xl md:text-2xl font-extrabold mb-8 p-2 border-b border-indigo-700 dark:border-gray-700 flex justify-between items-center">
        <span>🔑 License Portal</span>
        <!-- Close button for Mobile -->
        <button class="md:hidden text-white hover:text-red-300 dark:hover:text-red-500" onclick="toggleSidebar()">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
        </button>
    </div>
    
    <nav class="flex-1 overflow-y-auto">
        <!-- Dashboard Link -->
        <a href="dashboard.php" class="flex items-center p-3 text-white dark:text-gray-300 rounded-lg transition duration-200 hover:bg-indigo-700 dark:hover:bg-gray-700 mb-2 <?php echo is_active_page('dashboard.php'); ?>">
            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7m-2 2v10a1 1 0 01-1 1h-6a1 1 0 01-1-1v-4a1 1 0 00-1-1H9a1 1 0 00-1 1v4a1 1 0 01-1 1H5a1 1 0 01-1-1V9a1 1 0 011-1h6"></path></svg>
            Dashboard
        </a>
        
        <!-- Licenses Link -->
        <a href="licenses.php" class="flex items-center p-3 text-white dark:text-gray-300 rounded-lg transition duration-200 hover:bg-indigo-700 dark:hover:bg-gray-700 mb-2 <?php echo is_active_page('licenses.php'); ?>">
            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2v2m-6-2a2 2 0 00-2 2v2m0-8h6m-3 3v2m0 0h6m-3-6v6"></path></svg>
            Licenses
        </a>
        
        <!-- Domains Link -->
        <a href="domains.php" class="flex items-center p-3 text-white dark:text-gray-300 rounded-lg transition duration-200 hover:bg-indigo-700 dark:hover:bg-gray-700 mb-2 <?php echo is_active_page('domains.php'); ?>">
            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m-9 9h6m-3 3l3-3m-3 3l3-3"></path></svg>
            Domains
        </a>

        <!-- Settings Link (New) -->
        <a href="settings.php" class="flex items-center p-3 text-white dark:text-gray-300 rounded-lg transition duration-200 hover:bg-indigo-700 dark:hover:bg-gray-700 mb-2 <?php echo is_active_page('settings.php'); ?>">
            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37a1.724 1.724 0 002.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
            Settings
        </a>
    </nav>
    <div class="p-2 border-t border-indigo-700 dark:border-gray-700 mt-4">
        <!-- Log Out Link -->
        <a href="logout.php" class="flex items-center p-3 text-red-300 dark:text-red-400 rounded-lg transition duration-200 hover:bg-red-700 dark:hover:bg-red-800 hover:text-white">
            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
            Log Out
        </a>
    </div>
</aside>