<?php
$page_title = "Password Hasher Utility";
// এই ফাইলটিতে config.php বা check_login() অন্তর্ভুক্ত করার দরকার নেই,
// কারণ এটি একটি একক ইউটিলিটি টুল যা অ্যাডমিন অ্যাকাউন্টের বাইরে পাসওয়ার্ড হ্যাশ তৈরি করতে ব্যবহৃত হয়।

$password = '';
$hashed_password = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $password = $_POST['password'];
    
    // PHP-এর সুরক্ষিত hashing ফাংশন ব্যবহার করা হয়েছে (Bcrypt)
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - License Portal Utility</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50 flex items-center justify-center min-h-screen">
    <div class="w-full max-w-lg">
        <div class="bg-white p-8 rounded-xl shadow-2xl border border-indigo-100">
            <h2 class="text-3xl font-bold text-center text-indigo-800 mb-6">
                Password Hashing Tool
            </h2>
            <p class="text-center text-gray-500 mb-8">Generate a secure hash for saving new admin passwords in the database.</p>

            <!-- Input Form -->
            <form action="password_hasher.php" method="POST" class="space-y-6 mb-8">
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700">Enter Plain Text Password</label>
                    <input type="text" id="password" name="password" required 
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 p-3 border"
                           value="<?php echo htmlspecialchars($password); ?>">
                </div>

                <button type="submit" 
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-150">
                    Generate Hash
                </button>
            </form>

            <!-- Output Result -->
            <?php if ($hashed_password): ?>
                <div class="space-y-4 bg-indigo-50 p-6 rounded-lg border border-indigo-200">
                    <h3 class="text-lg font-semibold text-indigo-800">Generated Hash (Copy this to DB):</h3>
                    <div class="relative">
                        <textarea id="hashedOutput" readonly rows="3" class="font-mono text-sm w-full p-3 bg-white border border-indigo-300 rounded-md select-all focus:outline-none focus:ring-2 focus:ring-indigo-500"><?php echo htmlspecialchars($hashed_password); ?></textarea>
                        
                        <button onclick="copyHash()" class="absolute top-2 right-2 bg-indigo-500 text-white text-xs font-medium py-1 px-3 rounded-full hover:bg-indigo-600 transition duration-150">
                            Copy Hash
                        </button>
                    </div>
                    <p class="text-xs text-gray-600">This hash is secure and can be stored directly in your `admin_users` table.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function copyHash() {
            const textarea = document.getElementById('hashedOutput');
            textarea.select();
            
            // Use clipboard API for modern browsers
            try {
                navigator.clipboard.writeText(textarea.value);
                alert('Hash copied to clipboard!');
            } catch (err) {
                // Fallback for older browsers
                document.execCommand('copy');
                alert('Hash copied to clipboard!');
            }
        }
    </script>
</body>
</html>