<?php
// Set Timezone
date_default_timezone_set('Asia/Dhaka');

ob_start();
$page_title = "License Details";
include 'header.php'; 

// --- AUTO-EXPIRE LOGIC ---
if (isset($pdo) && $pdo instanceof PDO) {
    $expire_sql = "UPDATE license_keys SET is_active = 0 WHERE is_active = 1 AND expires_at IS NOT NULL AND expires_at <= NOW()";
    $pdo->exec($expire_sql);
}

// --- HELPER FUNCTIONS ---
function execute_query($pdo, $sql, $params = [], $fetch_all = false) {
    if (!isset($pdo) || !$pdo instanceof PDO) return $fetch_all ? [] : 0;
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        if (strpos(trim(strtoupper($sql)), 'SELECT COUNT') === 0) return (int)$stmt->fetchColumn();
        if ($fetch_all) return $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $stmt->fetch(PDO::FETCH_ASSOC); 
    } catch (PDOException $e) { return $fetch_all ? [] : null; }
}

// --- ACTIONS ---
$license_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lid = (int)$_POST['license_id_post'];
    
    // 1. Delete Domain
    if ($_POST['action'] === 'delete_domain') {
        $did = (int)$_POST['domain_id'];
        $pdo->prepare("DELETE FROM client_domains WHERE id = ?")->execute([$did]);
        header("Location: license_details.php?id=$lid&msg=deleted"); exit;
    }
    
    // 2. Activate Domain (STRICT MODE: Deny if ANY exist)
    if ($_POST['action'] === 'activate_domain') {
        $did = (int)$_POST['domain_id'];
        
        // CHECK: Is there ALREADY an active domain for this key?
        $count = (int)$pdo->query("SELECT COUNT(*) FROM client_domains WHERE license_key_id = $lid AND status = 'active'")->fetchColumn();
        
        if ($count > 0) {
            header("Location: license_details.php?id=$lid&error=limit_strict"); 
            exit;
        }
        
        $pdo->prepare("UPDATE client_domains SET status = 'active' WHERE id = ?")->execute([$did]);
        header("Location: license_details.php?id=$lid&msg=activated"); exit;
    }
    
    // 3. Revoke Domain
    if ($_POST['action'] === 'revoke_domain') {
        $pdo->prepare("UPDATE client_domains SET status = 'revoked' WHERE id = ?")->execute([(int)$_POST['domain_id']]);
        header("Location: license_details.php?id=$lid&msg=revoked"); exit;
    }

    // 4. Edit License Details
    if ($_POST['action'] === 'edit_license_details') {
        $title = trim($_POST['edit_title']);
        $expiry = trim($_POST['edit_expiry']);
        $expires_at = !empty($expiry) ? date("Y-m-d H:i:s", strtotime($expiry)) : null;
        
        $mod_ecom = isset($_POST['edit_mod_ecommerce']) ? 1 : 0;
        $mod_file = isset($_POST['edit_mod_filesystem']) ? 1 : 0;
        $mod_memb = isset($_POST['edit_mod_membership']) ? 1 : 0;
        
        $pdo->prepare("UPDATE license_keys SET title = ?, expires_at = ?, module_ecommerce = ?, module_filesystem = ?, module_membership = ? WHERE id = ?")
            ->execute([$title, $expires_at, $mod_ecom, $mod_file, $mod_memb, $lid]);
        header("Location: license_details.php?id=$lid&msg=updated"); exit;
    }
}

// --- DATA FETCH ---
$license = execute_query($pdo, "SELECT * FROM license_keys WHERE id = ?", [$license_id]);
$domains = execute_query($pdo, "SELECT * FROM client_domains WHERE license_key_id = ? ORDER BY activated_at DESC", [$license_id], true);

// Count active domains
$active_count = 0;
foreach($domains as $d) { if($d['status'] === 'active') $active_count++; }
$limit_reached = ($active_count >= 1);

function get_status_ui($active, $expire) {
    if ($active == 0) return ['bg' => 'bg-red-100 text-red-800 border-red-200', 'label' => 'Inactive', 'icon' => 'fa-ban'];
    if ($expire && strtotime($expire) < time()) return ['bg' => 'bg-amber-100 text-amber-800 border-amber-200', 'label' => 'Expired', 'icon' => 'fa-clock'];
    return ['bg' => 'bg-emerald-100 text-emerald-800 border-emerald-200', 'label' => 'Active', 'icon' => 'fa-check-circle'];
}
?>

<div class="bg-gray-50 dark:bg-gray-900 min-h-screen pb-12 font-sans transition-colors duration-200">
    
    <!-- Top Navigation -->
    <div class="bg-white/90 dark:bg-gray-800/90 border-b border-gray-200 dark:border-gray-700 sticky top-0 z-30 backdrop-blur-md">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex justify-between h-16 items-center">
            <a href="licenses.php" class="group inline-flex items-center text-sm font-semibold text-gray-500 hover:text-indigo-600 dark:text-gray-400 dark:hover:text-indigo-400 transition-colors">
                <span class="p-1.5 rounded-lg bg-gray-100 dark:bg-gray-700 mr-2 group-hover:bg-indigo-50 dark:group-hover:bg-indigo-900/50 transition-colors">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                </span>
                Back to Licenses
            </a>
            <span class="text-xs font-mono font-bold text-gray-400 dark:text-gray-500 bg-gray-100 dark:bg-gray-700/50 px-3 py-1 rounded-full border border-gray-200 dark:border-gray-600">ID: #<?= $license_id ?></span>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-8">
        
        <!-- Toast Notification (Success) -->
        <?php if(isset($_GET['msg'])): ?>
        <div id="toast" class="fixed top-24 right-5 z-50 flex items-center w-full max-w-xs p-4 space-x-4 text-gray-500 bg-white rounded-xl shadow-2xl dark:text-gray-400 dark:bg-gray-800 border border-emerald-100 dark:border-gray-700 animate-fade-in-down" role="alert">
            <div class="inline-flex items-center justify-center flex-shrink-0 w-8 h-8 text-emerald-500 bg-emerald-100 rounded-lg dark:bg-emerald-900/50 dark:text-emerald-300">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg>
            </div>
            <div class="ml-3 text-sm font-medium text-gray-800 dark:text-gray-200">Action Successful</div>
            <button onclick="document.getElementById('toast').remove()" class="ml-auto -mx-1.5 -my-1.5 bg-white text-gray-400 hover:text-gray-900 rounded-lg focus:ring-2 focus:ring-gray-300 p-1.5 hover:bg-gray-100 inline-flex h-8 w-8 dark:text-gray-500 dark:hover:text-white dark:bg-gray-800 dark:hover:bg-gray-700">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
            </button>
        </div>
        <?php endif; ?>

        <!-- Error Toast (Limit Strict) -->
        <?php if(isset($_GET['error']) && $_GET['error'] == 'limit_strict'): ?>
        <div id="error-toast" class="fixed top-24 right-5 z-50 flex items-center w-full max-w-sm p-4 mb-4 text-rose-800 border-l-4 border-rose-500 bg-white dark:text-rose-400 dark:bg-gray-800 shadow-2xl rounded-r-xl animate-shake" role="alert">
            <svg class="flex-shrink-0 w-6 h-6 text-rose-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            <div class="ml-3">
                <h3 class="text-sm font-bold">Access Denied</h3>
                <p class="text-xs mt-1">Maximum domain limit reached (1/1). You must revoke the existing active domain first.</p>
            </div>
            <button type="button" class="ml-auto -mx-1.5 -my-1.5 bg-white text-gray-400 hover:text-rose-900 rounded-lg focus:ring-2 focus:ring-rose-300 p-1.5 hover:bg-rose-50 inline-flex h-8 w-8 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-gray-700" onclick="document.getElementById('error-toast').remove()">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
            </button>
        </div>
        <?php endif; ?>

        <?php if ($license): $statusUI = get_status_ui($license['is_active'], $license['expires_at']); ?>

        <!-- Header Card -->
        <div class="mb-8 bg-white dark:bg-gray-800 rounded-2xl shadow-xl border border-gray-100 dark:border-gray-700 p-6 md:p-8 relative overflow-hidden group">
            <!-- Decorative Background -->
            <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                <svg class="w-40 h-40 text-indigo-600 dark:text-indigo-400" fill="currentColor" viewBox="0 0 24 24"><path d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37a1.724 1.724 0 002.572-1.065z"></path><path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
            </div>
            
            <div class="relative z-10 flex flex-col md:flex-row md:items-start md:justify-between">
                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-3 mb-3">
                        <h2 class="text-3xl font-black text-gray-900 dark:text-white tracking-tight">
                            <?= htmlspecialchars($license['title']) ?>
                        </h2>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wide border <?= $statusUI['bg'] ?>">
                            <span class="w-2 h-2 rounded-full mr-2 bg-current animate-pulse"></span>
                            <?= $statusUI['label'] ?>
                        </span>
                    </div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400 flex flex-wrap gap-4 items-center">
                        <span class="flex items-center"><svg class="mr-1.5 h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg> Created: <?= date("M j, Y", strtotime($license['created_at'])) ?></span>
                        <span class="hidden md:inline w-1 h-1 bg-gray-300 rounded-full"></span>
                        <span class="flex items-center"><svg class="mr-1.5 h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg> Expires: <span class="ml-1 font-bold <?= $license['expires_at'] ? 'text-gray-700 dark:text-gray-200' : 'text-indigo-500' ?>"><?= $license['expires_at'] ? date("M j, Y", strtotime($license['expires_at'])) : "Lifetime" ?></span></span>
                    </p>
                </div>
                <button onclick="document.getElementById('edit-detail-modal').classList.remove('hidden')" class="mt-5 md:mt-0 inline-flex items-center px-5 py-2.5 border border-gray-200 dark:border-gray-600 rounded-xl shadow-sm text-sm font-bold text-gray-700 dark:text-white bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 transition-all transform hover:-translate-y-0.5">
                    <svg class="-ml-1 mr-2 h-4 w-4 text-gray-500 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                    Edit License
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left: Info -->
            <div class="lg:col-span-1 space-y-6">
                
                <!-- Keys Card -->
                <div class="bg-white dark:bg-gray-800 shadow-lg rounded-2xl p-6 border border-gray-100 dark:border-gray-700">
                    <h3 class="text-xs font-black text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-5">Credentials</h3>
                    <div class="space-y-5">
                        <div>
                            <label class="block text-xs font-bold text-gray-500 dark:text-gray-400 mb-1.5 ml-1">API Key</label>
                            <div class="relative group">
                                <input readonly value="<?= $license['api_key'] ?>" class="block w-full px-4 py-3 text-xs font-mono text-gray-600 dark:text-gray-300 bg-gray-50 dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl focus:ring-0">
                                <button onclick="navigator.clipboard.writeText('<?= $license['api_key'] ?>')" class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-400 hover:text-indigo-600 transition-colors" title="Copy">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path></svg>
                                </button>
                            </div>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-rose-500 dark:text-rose-400 mb-1.5 ml-1">Secret Key</label>
                            <div class="relative group">
                                <input readonly value="<?= $license['secret_key'] ?>" class="block w-full px-4 py-3 text-xs font-mono text-rose-600 dark:text-rose-400 bg-rose-50 dark:bg-rose-900/10 border border-rose-100 dark:border-rose-900/30 rounded-xl focus:ring-0">
                                <button onclick="navigator.clipboard.writeText('<?= $license['secret_key'] ?>')" class="absolute inset-y-0 right-0 flex items-center pr-3 text-rose-400 hover:text-rose-600 transition-colors" title="Copy">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path></svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Module Access Card -->
                <div class="bg-white dark:bg-gray-800 shadow-lg rounded-2xl p-6 border border-gray-100 dark:border-gray-700">
                    <h3 class="text-xs font-black text-gray-400 dark:text-gray-500 uppercase tracking-widest mb-4">Module Permissions</h3>
                    <div class="space-y-2">
                        <?php 
                        $mod_list = [
                            ['eCommerce Shop', $license['module_ecommerce']],
                            ['File System', $license['module_filesystem']],
                            ['Membership', $license['module_membership']]
                        ];
                        foreach($mod_list as $mod): ?>
                        <div class="flex justify-between items-center p-3 rounded-lg <?= $mod[1] ? 'bg-indigo-50/50 dark:bg-indigo-900/20 border border-indigo-100 dark:border-indigo-800' : 'bg-gray-50 dark:bg-gray-700/50 border border-gray-100 dark:border-gray-600 opacity-70' ?>">
                            <span class="text-sm font-bold text-gray-700 dark:text-gray-300"><?= $mod[0] ?></span>
                            <?php if($mod[1]): ?>
                                <svg class="h-5 w-5 text-indigo-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                            <?php else: ?>
                                <svg class="h-5 w-5 text-gray-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path></svg>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Right: Domains -->
            <div class="lg:col-span-2">
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-2xl overflow-hidden border border-gray-100 dark:border-gray-700 flex flex-col h-full">
                    <div class="px-6 py-5 bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700 flex justify-between items-center">
                        <div class="flex items-center gap-3">
                            <h3 class="text-lg font-bold text-gray-900 dark:text-white">Registered Domains</h3>
                            <span class="bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300 text-xs font-bold px-2.5 py-0.5 rounded-md border border-gray-200 dark:border-gray-600">
                                Limit: <?= $active_count ?> / 1
                            </span>
                        </div>
                        
                        <?php if($limit_reached): ?>
                            <span class="text-xs font-bold text-amber-600 bg-amber-50 dark:bg-amber-900/30 px-3 py-1 rounded-full border border-amber-100 dark:border-amber-800 flex items-center">
                                <span class="w-1.5 h-1.5 rounded-full bg-amber-500 mr-1.5 animate-pulse"></span>
                                Slot Full
                            </span>
                        <?php else: ?>
                            <span class="text-xs font-bold text-emerald-600 bg-emerald-50 dark:bg-emerald-900/30 px-3 py-1 rounded-full border border-emerald-100 dark:border-emerald-800 flex items-center">
                                <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 mr-1.5"></span>
                                Slot Available
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="overflow-x-auto flex-grow">
                        <table class="min-w-full divide-y divide-gray-100 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-900/50">
                                <tr>
                                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-wider">Domain</th>
                                    <th class="px-6 py-4 text-center text-xs font-bold text-gray-400 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-4 text-right text-xs font-bold text-gray-400 uppercase tracking-wider">Control</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-100 dark:divide-gray-700">
                                <?php foreach ($domains as $d): ?>
                                <tr class="group hover:bg-gray-50/80 dark:hover:bg-gray-700/20 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="flex-shrink-0 h-9 w-9 rounded-full bg-indigo-50 dark:bg-indigo-900/30 flex items-center justify-center text-indigo-600 dark:text-indigo-400 text-xs font-bold border border-indigo-100 dark:border-indigo-800">
                                                WWW
                                            </div>
                                            <div class="ml-4">
                                                <div class="text-sm font-bold text-gray-900 dark:text-white"><?= htmlspecialchars($d['domain_name']) ?></div>
                                                <div class="text-xs text-gray-400 mt-0.5 font-mono">ID: <?= $d['id'] ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-center">
                                        <?php if($d['status'] == 'active'): ?>
                                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold bg-emerald-100 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-400">
                                                <span class="w-1.5 h-1.5 rounded-full bg-current mr-1.5"></span> Active
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold bg-gray-100 text-gray-500 dark:bg-gray-700 dark:text-gray-400">
                                                <?= ucfirst($d['status']) ?>
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex items-center justify-end space-x-2">
                                            
                                            <!-- Toggle Status -->
                                            <?php if($d['status'] == 'active'): ?>
                                                <form method="POST" class="inline">
                                                    <input type="hidden" name="action" value="revoke_domain">
                                                    <input type="hidden" name="domain_id" value="<?= $d['id'] ?>">
                                                    <input type="hidden" name="license_id_post" value="<?= $license_id ?>">
                                                    <button type="submit" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-bold rounded-lg text-amber-700 bg-amber-100 hover:bg-amber-200 dark:bg-amber-900/30 dark:text-amber-400 dark:hover:bg-amber-900/50 transition-colors">
                                                        Revoke
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <form method="POST" class="inline">
                                                    <input type="hidden" name="action" value="activate_domain">
                                                    <input type="hidden" name="domain_id" value="<?= $d['id'] ?>">
                                                    <input type="hidden" name="license_id_post" value="<?= $license_id ?>">
                                                    <button type="submit" 
                                                        class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-bold rounded-lg transition-colors <?= $limit_reached ? 'bg-gray-100 text-gray-400 cursor-not-allowed' : 'text-emerald-700 bg-emerald-100 hover:bg-emerald-200 dark:bg-emerald-900/30 dark:text-emerald-400 dark:hover:bg-emerald-900/50' ?>"
                                                        <?= $limit_reached ? 'disabled title="Limit reached. Revoke active domain first."' : '' ?>>
                                                        Activate
                                                    </button>
                                                </form>
                                            <?php endif; ?>

                                            <!-- Delete -->
                                            <form method="POST" class="inline" onsubmit="return confirm('Delete this domain permanently?');">
                                                <input type="hidden" name="action" value="delete_domain">
                                                <input type="hidden" name="domain_id" value="<?= $d['id'] ?>">
                                                <input type="hidden" name="license_id_post" value="<?= $license_id ?>">
                                                <button type="submit" class="p-1.5 text-gray-400 hover:text-rose-600 dark:hover:text-rose-400 transition-colors rounded-md hover:bg-rose-50 dark:hover:bg-rose-900/20" title="Delete">
                                                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; if(empty($domains)) echo "<tr><td colspan='3' class='px-6 py-12 text-center text-gray-400 italic'>No registered domains found.</td></tr>"; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <?php else: ?>
            <div class="text-center mt-20">
                <div class="inline-flex items-center justify-center w-20 h-20 rounded-full bg-gray-100 dark:bg-gray-800 mb-6">
                    <svg class="h-10 w-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">License Not Found</h2>
                <p class="text-gray-500 dark:text-gray-400 mb-6">The requested license key ID does not exist or has been deleted.</p>
                <a href="licenses.php" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-xl text-white bg-indigo-600 hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition-all">
                    Return to Dashboard
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Edit Modal -->
<?php if ($license): ?>
<div id="edit-detail-modal" class="fixed inset-0 z-50 hidden overflow-y-auto" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-900/75 transition-opacity backdrop-blur-sm" onclick="document.getElementById('edit-detail-modal').classList.add('hidden')"></div>
        <div class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-2xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-md sm:w-full border border-gray-200 dark:border-gray-700">
            <div class="bg-indigo-600 px-6 py-5"><h3 class="text-lg font-bold text-white">Edit License Settings</h3></div>
            <form method="POST" class="px-6 py-6 space-y-6">
                <input type="hidden" name="action" value="edit_license_details">
                <input type="hidden" name="license_id_post" value="<?= $license_id ?>">
                
                <div>
                    <label class="block text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wide mb-2">License Title</label>
                    <input type="text" name="edit_title" value="<?= htmlspecialchars($license['title']) ?>" class="w-full px-4 py-3 rounded-xl border border-gray-200 dark:border-gray-600 dark:bg-gray-700 dark:text-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all">
                </div>
                
                <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-xl border border-gray-100 dark:border-gray-600">
                    <label class="block text-xs font-bold text-gray-500 dark:text-gray-400 uppercase mb-3">Module Permissions</label>
                    <div class="space-y-3">
                        <label class="flex items-center space-x-3 cursor-pointer group">
                            <input type="checkbox" name="edit_mod_ecommerce" value="1" <?= $license['module_ecommerce']?'checked':'' ?> class="h-5 w-5 text-indigo-600 rounded border-gray-300 focus:ring-indigo-500 transition-all">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-200 group-hover:text-indigo-600 transition-colors">eCommerce Shop</span>
                        </label>
                        <label class="flex items-center space-x-3 cursor-pointer group">
                            <input type="checkbox" name="edit_mod_filesystem" value="1" <?= $license['module_filesystem']?'checked':'' ?> class="h-5 w-5 text-indigo-600 rounded border-gray-300 focus:ring-indigo-500 transition-all">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-200 group-hover:text-indigo-600 transition-colors">File Delivery System</span>
                        </label>
                        <label class="flex items-center space-x-3 cursor-pointer group">
                            <input type="checkbox" name="edit_mod_membership" value="1" <?= $license['module_membership']?'checked':'' ?> class="h-5 w-5 text-indigo-600 rounded border-gray-300 focus:ring-indigo-500 transition-all">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-200 group-hover:text-indigo-600 transition-colors">Membership Packages</span>
                        </label>
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wide mb-2">Expiration Date</label>
                    <input type="datetime-local" name="edit_expiry" value="<?= $license['expires_at'] ? date('Y-m-d\TH:i', strtotime($license['expires_at'])) : '' ?>" class="w-full px-4 py-3 rounded-xl border border-gray-200 dark:border-gray-600 dark:bg-gray-700 dark:text-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all">
                    <p class="text-xs text-gray-400 mt-1">Leave empty for lifetime access.</p>
                </div>

                <div class="flex justify-end gap-3 pt-2">
                    <button type="button" onclick="document.getElementById('edit-detail-modal').classList.add('hidden')" class="px-5 py-2.5 bg-white border border-gray-200 text-gray-700 font-bold rounded-xl hover:bg-gray-50 transition-colors">Cancel</button>
                    <button class="px-6 py-2.5 bg-indigo-600 text-white font-bold rounded-xl hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition-all transform hover:-translate-y-0.5">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<style>
    @keyframes fade-in-down { 0% { opacity: 0; transform: translateY(-20px); } 100% { opacity: 1; transform: translateY(0); } }
    .animate-fade-in-down { animation: fade-in-down 0.5s ease-out; }
    @keyframes shake { 0%, 100% { transform: translateX(0); } 10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); } 20%, 40%, 60%, 80% { transform: translateX(5px); } }
    .animate-shake { animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) both; }
</style>

<?php include 'footer.php'; ob_end_flush(); ?>