<?php
// =======================================================
// PORTAL.IFIXROM.COM - CORE CONFIGURATION FILE
// =======================================================

// --- Database Connection Settings (Update these details) ---
define('DB_HOST', 'localhost');
define('DB_USER', 'ifixrom1_License');
define('DB_PASS', 'cei{bTHhKGHV');
define('DB_NAME', 'ifixrom1_License'); 
define('ADMIN_TABLE', 'portal_admins');
define('DEBUG_MODE', true);

// --- Global Configuration ---
define('SITE_URL', 'https://portal.ifixrom.com');
define('SITE_NAME', 'iFixROM License Portal');

// --- Session & Security ---
session_start();

/**
 * Database Connection Function
 * @return PDO
 */
function db_connect() {
    try {
        // Use constants for connection details
        $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8", DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        return $pdo;
    } catch (PDOException $e) {
        // In a real environment, log this error instead of dying
        if (DEBUG_MODE) {
             die("Connection failed: " . $e->getMessage());
        } else {
             error_log("Database connection failed: " . $e->getMessage());
             http_response_code(500);
             exit;
        }
    }
}

// Login Check Function - Redirects to login page if not authenticated
function check_login() {
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        header('Location: login.php');
        exit();
    }
}

// Function to generate a strong license key (Hexadecimal)
function generate_license_key($length = 32) {
    if (function_exists('random_bytes')) {
        return bin2hex(random_bytes($length / 2));
    }
    // Fallback if random_bytes is unavailable (less secure)
    return substr(str_shuffle(str_repeat('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', $length / 2)), 0, $length);
}

// Global PDO Connection Instance
$pdo = db_connect();

// Global logged-in user variable (for display)
$logged_in_user = $_SESSION['admin_username'] ?? 'Guest';

?>